#!/bin/bash
export datasets1="Cora CiteSeer PubMed cs wikics"
export datasets2="physics OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_reverse="1.0 0.9999 0.999 0.99 0.9 0.8 0.7 0.6 0.5 0.4 0.3 0.2 0.1 0.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=1

# w/p missing rates
# for missing_rate in $missing_rates
# do
# python main.py --dataset Cora --missing_type structural --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type vec_ind --lp_alpha 0.99 --lamb 1.0 --n_runs 3 --gpu ${gpu} --gnn GCN
# python main.py --dataset Cora --missing_type structural --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type mat_share --lp_alpha 0.99 --lamb 1.0 --n_runs 3 --gpu ${gpu} --gnn GCN
# python main.py --dataset Cora --missing_type structural --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type mat_ind --lp_alpha 0.99 --lamb 1.0 --n_runs 3 --gpu ${gpu} --gnn GCN
# done

# for missing_rate in $missing_rates
# do
# python main.py --dataset Cora --missing_type structural --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type mr --lp_alpha 0.99 --lamb 1.0 --n_runs 3 --gpu ${gpu} --gnn GCN
# done

for missing_rate in $missing_rates_reverse
do
python main.py --dataset OGBN-Arxiv --missing_type structural --missing_rate ${missing_rate} --embedder GOODIE_2_attn --attn_type vec_share --lp_alpha 0.8 --lamb 0.001 --n_runs 3 --gpu ${gpu} --gnn GCN
python main.py --dataset OGBN-Arxiv --missing_type structural --missing_rate ${missing_rate} --embedder GOODIE_2_attn --attn_type vec_ind --lp_alpha 0.8 --lamb 0.001 --n_runs 3 --gpu ${gpu} --gnn GCN
python main.py --dataset OGBN-Arxiv --missing_type structural --missing_rate ${missing_rate} --embedder GOODIE_2_attn --attn_type mat_share --lp_alpha 0.8 --lamb 0.001 --n_runs 3 --gpu ${gpu} --gnn GCN
python main.py --dataset OGBN-Arxiv --missing_type structural --missing_rate ${missing_rate} --embedder GOODIE_2_attn --attn_type mat_ind --lp_alpha 0.8 --lamb 0.001 --n_runs 3 --gpu ${gpu} --gnn GCN
python main.py --dataset OGBN-Arxiv --missing_type structural --missing_rate ${missing_rate} --embedder GOODIE_2_attn --attn_type mr --lp_alpha 0.8 --lamb 0.001 --n_runs 3 --gpu ${gpu} --gnn GCN
done